/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWParticipantHistory;
import filenet.vw.api.VWProcess;
import filenet.vw.api.VWStepElement;
import filenet.vw.api.VWUserInfo;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataField;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkParticipantHistory;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.VWTrkTestDataField;
import filenet.vw.toolkit.runtime.VWTrkWork;
import filenet.vw.toolkit.runtime.VWTrkWorkObject;
import filenet.vw.toolkit.runtime.images.VWImageLoader;
import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;

public final class VWTrkParticipant {
    private VWTrkWork m_work = null;
    private VWTrkParticipantHistory m_participantHistory = null;
    private VWTrkWorkObject m_workObject = null;
    private boolean m_bCanReassign = false;
    private boolean m_bCanReturnToSource = false;
    private String m_returnToSourceName = null;
    private VWParticipant m_participant = null;
    private VWParticipant m_currentUser = null;
    private Vector m_dataFields = new Vector();
    private Vector m_attachments = new Vector();
    private Vector m_workflowGroups = new Vector();
    private Date m_deadline = null;
    private int m_lockStatus = 0;
    private VWParticipant m_lockedUser = null;

    public VWTrkParticipant(VWTrkWork work, VWParticipantHistory history) {
        this.m_work = work;
        this.m_participantHistory = new VWTrkParticipantHistory(this, history);
    }

    public VWTrkParticipant(VWTrkWork work, VWTrkParticipantHistory history) {
        this.m_work = work;
        this.m_participantHistory = history;
    }

    public VWTrkParticipant(VWTrkWork work, VWTrkWorkObject workObject) {
        try {
            this.m_work = work;
            this.m_participantHistory = new VWTrkParticipantHistory(this, workObject);
            this.setWorkObject(workObject);
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    public VWTrkStep getStep() {
        VWTrkStepOccurrence occurrence = this.getStepOccurrence();
        if (occurrence != null) {
            return occurrence.getStep();
        }
        return null;
    }

    public VWTrkStepOccurrence getStepOccurrence() {
        if (this.m_work != null) {
            return this.m_work.getStepOccurrence();
        }
        return null;
    }

    public VWTrkWork getWork() {
        return this.m_work;
    }

    public VWTrkParticipantHistory getParticipantHistory() {
        return this.m_participantHistory;
    }

    public void setWorkObject(VWTrkWorkObject workObject) {
        if (this.isLockedByCurrentUser()) {
            return;
        }
        this.m_workObject = workObject;
        this.m_participant = null;
        this.getLockedStatus();
        this.initFields();
        if (this.m_workObject != null) {
            try {
                VWStepElement stepElement = this.m_workObject.fetchStepElement();
                if (stepElement != null) {
                    this.m_bCanReturnToSource = stepElement.getCanReturnToSource();
                    this.m_bCanReassign = stepElement.getCanReassign();
                    this.m_returnToSourceName = null;
                }
            }
            catch (VWException ex) {
                this.m_bCanReturnToSource = false;
                this.m_bCanReassign = false;
                this.m_returnToSourceName = null;
            }
        }
    }

    protected void initFields() {
        try {
            VWTrkTestDataField[] dfCollection = this.m_workObject.getDataFields();
            if (dfCollection == null) {
                return;
            }
            for (int i = 0; i < dfCollection.length; ++i) {
                VWTrkTestDataField vwDataField = dfCollection[i];
                try {
                    if (vwDataField.getIsSystemField()) continue;
                    VWTrkDataField dataField = new VWTrkDataField(vwDataField);
                    switch (vwDataField.getFieldType()) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: 
                        case 16: 
                        case 128: {
                            this.m_dataFields.addElement(dataField);
                            break;
                        }
                        case 32: {
                            this.m_attachments.addElement(dataField);
                            break;
                        }
                        case 64: {
                            this.m_workflowGroups.addElement(dataField);
                        }
                    }
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    public VWTrkWorkObject getParticipantWorkObject() {
        return this.m_workObject;
    }

    private VWParticipant getCurrentUser() {
        try {
            VWUserInfo userInfo;
            if (this.m_currentUser == null && (userInfo = VWDefaultSessionProxy.fetchCurrentUserInfo()) != null) {
                this.m_currentUser = userInfo.getNamePx();
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
        return this.m_currentUser;
    }

    public int getLockedStatus() {
        if (this.m_workObject == null) {
            this.m_lockStatus = 0;
        } else {
            try {
                int vwLockStatus = this.m_workObject.getLockedStatus();
                switch (vwLockStatus) {
                    case 0: {
                        this.m_lockStatus = 1;
                        break;
                    }
                    case 1: {
                        VWParticipant currentUser = this.getCurrentUser();
                        VWParticipant lockedUser = this.m_workObject.getLockedUser();
                        this.m_lockStatus = 4;
                        if (lockedUser == null || !VWStringUtils.compareUsers(lockedUser.getParticipantName(), currentUser.getParticipantName())) break;
                        this.m_lockStatus = 2;
                        break;
                    }
                    case 2: {
                        this.m_lockStatus = 8;
                    }
                }
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
                System.err.println(VWResource.s_failedToFetchLockedStatus);
            }
        }
        return this.m_lockStatus;
    }

    public ImageIcon getLockedStatusIcon() {
        ImageIcon icon = null;
        if (this.m_workObject == null || this.m_lockStatus == 0) {
            this.getLockedStatus();
        }
        switch (this.m_lockStatus) {
            case 1: {
                icon = VWImageLoader.createImageIcon("unlocked.gif");
                break;
            }
            case 4: 
            case 8: {
                icon = VWImageLoader.createImageIcon("lockedByOther.gif");
                break;
            }
            case 2: {
                icon = VWImageLoader.createImageIcon("lockedByUser.gif");
                break;
            }
        }
        return icon;
    }

    public boolean lockWork() {
        if (this.m_workObject != null && this.m_lockStatus == 1) {
            try {
                this.doLock(false);
                return true;
            }
            catch (VWException ex) {
                try {
                    if (this.m_workObject != null) {
                        this.m_workObject.doRefresh(false, false);
                    }
                }
                catch (VWException e) {
                    VWDebug.logException(e);
                }
                this.getLockedStatus();
                return false;
            }
        }
        return false;
    }

    public boolean unlockWork(boolean bSave, boolean bDispatch) {
        if (this.m_workObject == null) {
            return true;
        }
        switch (this.m_lockStatus) {
            case 0: 
            case 1: {
                return true;
            }
            case 4: 
            case 8: {
                return false;
            }
            case 2: {
                VWTrkWorkObject[] workObjects = new VWTrkWorkObject[]{this.m_workObject};
                try {
                    VWException[] ex = this.m_workObject.doUnlockMany(workObjects, bSave, bDispatch);
                    this.m_workObject.doRefresh(false, false);
                    this.m_lockStatus = this.getLockedStatus();
                    if (ex == null) {
                        return true;
                    }
                    return ex[0] == null;
                }
                catch (VWException e) {
                    VWDebug.logException(e);
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isActive() {
        return this.m_workObject != null;
    }

    public VWParticipant getUser() {
        if (this.m_workObject != null) {
            return this.getLockedUser();
        }
        if (this.m_participantHistory != null) {
            return this.m_participantHistory.getUser();
        }
        return null;
    }

    public VWParticipant getParticipant() {
        if (this.m_participant == null) {
            try {
                if (this.m_workObject != null) {
                    this.m_participant = this.m_workObject.getParticipant();
                } else if (this.m_participantHistory != null) {
                    this.m_participant = this.m_participantHistory.getParticipant();
                }
                if (this.m_participant != null && VWStringUtils.compare(this.m_participant.getParticipantName(), "(NONE)") == 0) {
                    this.m_participant = null;
                }
            }
            catch (VWException ex) {
                return new VWParticipant("");
            }
        }
        return this.m_participant;
    }

    public String getQueueName() {
        try {
            String queueName = null;
            if (this.m_participantHistory != null) {
                queueName = this.m_participantHistory.getQueueName();
            }
            if (queueName == null && this.m_workObject != null) {
                queueName = this.m_workObject.getCurrentQueueName();
            }
            return queueName;
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public String getOperationName() {
        try {
            String operationName = null;
            if (this.m_participantHistory != null) {
                operationName = this.m_participantHistory.getOperationName();
            }
            if (operationName == null && this.m_workObject != null) {
                operationName = this.m_workObject.getOperationName();
            }
            return operationName;
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public VWParticipant getLockedUser() {
        try {
            if (this.m_workObject != null) {
                this.m_lockedUser = this.m_workObject.getLockedUser();
                if (this.m_lockedUser != null && VWStringUtils.compare(this.m_lockedUser.getParticipantName(), "(NONE)") == 0) {
                    return null;
                }
                return this.m_lockedUser;
            }
        }
        catch (VWException ex) {
            return null;
        }
        return this.m_lockedUser;
    }

    public boolean getIsAltered() {
        try {
            if (this.m_workObject != null) {
                return this.m_workObject.getIsAltered();
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    public void updateHistory(VWParticipantHistory history) {
        if (this.m_participantHistory != null) {
            this.m_participantHistory.removeReferences();
        }
        this.m_participantHistory = new VWTrkParticipantHistory(this, history);
    }

    public void updateHistory(VWTrkParticipantHistory history) {
        if (this.m_participantHistory != null && history.getDateReceived().equals(this.m_participantHistory.getDateReceived())) {
            this.m_participantHistory.removeReferences();
            this.m_participantHistory = history;
        }
    }

    public void doComplete(String response, String comments) throws VWException {
        if (this.m_workObject != null && this.isLockedByCurrentUser()) {
            this.m_workObject.doComplete(response, comments);
            this.m_workObject = null;
            this.getLockedStatus();
        }
    }

    public void doReassign(VWParticipant participant, String comments, boolean delegateFlag, String queueName) throws VWException {
        if (this.m_workObject != null && this.isLockedByCurrentUser()) {
            if (comments != null) {
                this.m_workObject.setComment(comments);
            }
            this.m_workObject.doReassign(participant, delegateFlag, queueName);
            this.m_workObject = null;
            this.getLockedStatus();
            VWTrkStep step = this.getStep();
            if (step != null) {
                step.refreshStep(false);
            }
        }
    }

    public void doSave(boolean unlock) throws VWException {
        if (this.m_workObject != null && this.isLockedByCurrentUser()) {
            this.m_workObject.doSave(unlock);
        }
    }

    public void doDispatch() throws VWException {
        if (this.m_workObject != null && this.isLockedByCurrentUser()) {
            this.m_workObject.doDispatch();
            this.m_workObject = null;
            this.getLockedStatus();
        }
    }

    public void doReturnToSource(String comments) throws VWException {
        if (this.m_workObject != null && this.isLockedByCurrentUser()) {
            VWStepElement stepElement = this.m_workObject.fetchStepElement();
            stepElement.setComment(comments);
            stepElement.doReturnToSource();
            this.m_workObject = null;
            this.getLockedStatus();
        }
    }

    VWFieldDefinition getFieldDefinition(String name) {
        if (this.m_work != null) {
            return this.m_work.getFieldDefinition(name);
        }
        return null;
    }

    public Date getDateReceived() {
        return this.m_participantHistory.getDateReceived();
    }

    public Date getCompletionDate() {
        return this.m_participantHistory.getCompletionDate();
    }

    public String getComments() throws VWException {
        if (this.m_workObject != null) {
            return this.m_workObject.getComment();
        }
        return this.m_participantHistory.getComments();
    }

    public String getResponse() throws VWException {
        if (this.m_workObject != null) {
            return this.m_workObject.getSelectedResponse();
        }
        return this.m_participantHistory.getResponse();
    }

    public int getStatus() {
        int status = this.m_participantHistory.getStatus();
        if (status == 12) {
            status = this.getFurtherExceptionStatus(status);
        }
        if ((status == -1 || status == 1) && this.isActive()) {
            status = 1;
            int overdue = this.getOverdue();
            switch (overdue) {
                case 1: {
                    return 10;
                }
                case 2: {
                    return 9;
                }
            }
        }
        return status;
    }

    private int getFurtherExceptionStatus(int status) {
        if (status != 12) {
            return status;
        }
        VWTrkStepOccurrence stepOccurrence = this.getStepOccurrence();
        if (stepOccurrence == null) {
            return status;
        }
        VWTrkDataModel dataModel = stepOccurrence.getDataModel();
        if (dataModel == null) {
            return status;
        }
        VWProcess process = dataModel.getProcess();
        if (process == null) {
            return status;
        }
        int stepId = stepOccurrence.getStepId();
        int mapId = stepOccurrence.getStep().getMapId();
        Vector WOVector = dataModel.getExceptionWO(mapId, stepId);
        if (WOVector == null || WOVector.size() == 0) {
            status = 13;
        } else {
            VWTrkWork work = this.getWork();
            Vector participants = work.getParticipants();
            VWTrkParticipantHistory participantHistory = this.getParticipantHistory();
            VWParticipantHistory vwParticipantHistory = participantHistory.getVWParticipantHistory();
            boolean found = true;
            int foundIndex = -1;
            for (int i = 0; i < participants.size(); ++i) {
                VWTrkParticipant aParticipant = (VWTrkParticipant)participants.elementAt(i);
                VWTrkParticipantHistory aParticipantHistory = aParticipant.getParticipantHistory();
                VWParticipantHistory aVWParticipantHistory = aParticipantHistory.getVWParticipantHistory();
                if (aVWParticipantHistory.getIsSameParticipant(vwParticipantHistory)) {
                    found = true;
                    foundIndex = i;
                    continue;
                }
                try {
                    if (aVWParticipantHistory.getStepStatus() != vwParticipantHistory.getStepStatus() || aParticipantHistory.getWorkObjectNumber() != participantHistory.getWorkObjectNumber() || foundIndex <= -1 || foundIndex >= i) continue;
                    return 13;
                }
                catch (VWException ex) {
                    return 12;
                }
            }
        }
        return status;
    }

    public Date getDeadline() {
        if (this.m_deadline == null) {
            if (this.isActive()) {
                this.m_deadline = this.m_workObject.getDeadline();
            }
            if (this.m_deadline == null) {
                this.m_deadline = this.m_participantHistory.getOverdue();
            }
        }
        return this.m_deadline;
    }

    public int getOverdue() {
        if (this.isActive()) {
            return this.m_workObject.getOverdue();
        }
        return -1;
    }

    public void doTerminate() throws VWException {
        if (this.m_workObject != null && this.isLockedByCurrentUser()) {
            this.m_workObject.doTerminate();
            this.m_workObject = null;
            this.getLockedStatus();
        }
    }

    public void doLock(boolean override) throws VWException {
        if (this.m_workObject != null) {
            this.m_workObject.doLock(override);
            this.m_lockStatus = 2;
            this.m_lockedUser = this.getCurrentUser();
        }
    }

    public boolean isDataEditable() {
        if (this.isActive()) {
            int lockStatus = this.getLockedStatus();
            return lockStatus == 2;
        }
        return false;
    }

    public boolean isLockedByCurrentUser() {
        return 2 == this.getLockedStatus();
    }

    public boolean isLockedByOther() {
        if (this.isActive()) {
            int lockStatus = this.getLockedStatus();
            return (lockStatus & 0xC) != 0;
        }
        return false;
    }

    void removeWorkObject(boolean bSave) {
        Object obj;
        if (this.m_workObject != null) {
            if (bSave && this.isLockedByCurrentUser() && this.getIsAltered()) {
                try {
                    this.doSave(false);
                }
                catch (VWException ex) {
                    VWDebug.logException(ex);
                }
            }
            this.m_workObject.removeReferences();
            this.m_workObject = null;
            this.m_bCanReturnToSource = false;
            this.m_bCanReassign = false;
            this.m_returnToSourceName = null;
        }
        if (this.m_dataFields != null) {
            for (int i = 0; i < this.m_dataFields.size(); ++i) {
                obj = this.m_dataFields.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkDataField)) continue;
                ((VWTrkDataField)obj).removeReferences();
            }
            this.m_dataFields.removeAllElements();
            this.m_dataFields = null;
        }
        if (this.m_attachments != null) {
            for (int i = 0; i < this.m_attachments.size(); ++i) {
                obj = this.m_attachments.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkDataField)) continue;
                ((VWTrkDataField)obj).removeReferences();
            }
            this.m_attachments.removeAllElements();
            this.m_attachments = null;
        }
        if (this.m_workflowGroups != null) {
            for (int i = 0; i < this.m_workflowGroups.size(); ++i) {
                obj = this.m_workflowGroups.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkDataField)) continue;
                ((VWTrkDataField)obj).removeReferences();
            }
            this.m_workflowGroups.removeAllElements();
            this.m_workflowGroups = null;
        }
        this.getLockedStatus();
    }

    void save() throws VWException {
        if (this.m_workObject != null && this.isLockedByCurrentUser() && this.getIsAltered()) {
            this.doSave(false);
        }
    }

    void disgardChanges() {
        if (this.m_workObject != null && this.isLockedByCurrentUser() && this.getIsAltered()) {
            try {
                this.m_workObject.doRefresh(true, false);
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
        }
    }

    public boolean getCanReassign() {
        if (this.m_workObject != null) {
            return this.m_bCanReassign;
        }
        return false;
    }

    public boolean getCanReturnToSource() {
        if (this.m_workObject != null) {
            return this.m_bCanReturnToSource;
        }
        return false;
    }

    public String getReturnToSourceName() {
        if (this.m_workObject != null) {
            return this.m_returnToSourceName;
        }
        return null;
    }

    public void removeReferences() {
        Object obj;
        int i;
        this.m_work = null;
        if (this.m_participantHistory != null) {
            this.m_participantHistory.removeReferences();
            this.m_participantHistory = null;
        }
        if (this.m_workObject != null) {
            this.m_workObject.removeReferences();
            this.m_workObject = null;
        }
        if (this.m_dataFields != null) {
            for (i = 0; i < this.m_dataFields.size(); ++i) {
                obj = this.m_dataFields.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkDataField)) continue;
                ((VWTrkDataField)obj).removeReferences();
            }
            this.m_dataFields.removeAllElements();
            this.m_dataFields = null;
        }
        if (this.m_attachments != null) {
            for (i = 0; i < this.m_attachments.size(); ++i) {
                obj = this.m_attachments.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkDataField)) continue;
                ((VWTrkDataField)obj).removeReferences();
            }
            this.m_attachments.removeAllElements();
            this.m_attachments = null;
        }
        if (this.m_workflowGroups != null) {
            for (i = 0; i < this.m_workflowGroups.size(); ++i) {
                obj = this.m_workflowGroups.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkDataField)) continue;
                ((VWTrkDataField)obj).removeReferences();
            }
            this.m_workflowGroups.removeAllElements();
            this.m_workflowGroups = null;
        }
    }
}

